<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.111.3.9.10.38
Name: Actualiteitscheck Response
Description: 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.111.3.9.10.38-2016-12-16T133716">
    <title>Actualiteitscheck Response</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.38
Context: /
Item: (QUMT_IN020041NL)
-->
    <rule context="/" id="d836099e2762-false-d909787e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:QUMT_IN020041NL)&gt;=1">(QUMT_IN020041NL): element hl7:QUMT_IN020041NL is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:QUMT_IN020041NL)&lt;=1">(QUMT_IN020041NL): element hl7:QUMT_IN020041NL komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.38
Context: /hl7:QUMT_IN020041NL
Item: (QUMT_IN020041NL)
-->
    <rule context="/hl7:QUMT_IN020041NL" id="d836099e2766-false-d909812e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(QUMT_IN020041NL): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(QUMT_IN020041NL): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:creationTime[not(@nullFlavor)])&gt;=1">(QUMT_IN020041NL): element hl7:creationTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:creationTime[not(@nullFlavor)])&lt;=1">(QUMT_IN020041NL): element hl7:creationTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)])&gt;=1">(QUMT_IN020041NL): element hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)])&lt;=1">(QUMT_IN020041NL): element hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:interactionId[@root='2.16.840.1.113883.1.6'])&gt;=1">(QUMT_IN020041NL): element hl7:interactionId[@root='2.16.840.1.113883.1.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:interactionId[@root='2.16.840.1.113883.1.6'])&lt;=1">(QUMT_IN020041NL): element hl7:interactionId[@root='2.16.840.1.113883.1.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'])&gt;=1">(QUMT_IN020041NL): element hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'])&lt;=1">(QUMT_IN020041NL): element hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:processingCode[@code='P'][not(@nullFlavor)])&gt;=1">(QUMT_IN020041NL): element hl7:processingCode[@code='P'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:processingCode[@code='P'][not(@nullFlavor)])&lt;=1">(QUMT_IN020041NL): element hl7:processingCode[@code='P'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:processingModeCode[@code='T'][not(@nullFlavor)])&gt;=1">(QUMT_IN020041NL): element hl7:processingModeCode[@code='T'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:processingModeCode[@code='T'][not(@nullFlavor)])&lt;=1">(QUMT_IN020041NL): element hl7:processingModeCode[@code='T'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:acceptAckCode[@code='NE'][not(@nullFlavor)])&gt;=1">(QUMT_IN020041NL): element hl7:acceptAckCode[@code='NE'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:acceptAckCode[@code='NE'][not(@nullFlavor)])&lt;=1">(QUMT_IN020041NL): element hl7:acceptAckCode[@code='NE'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:acknowledgement[not(@nullFlavor)])&gt;=1">(QUMT_IN020041NL): element hl7:acknowledgement[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:acknowledgement[not(@nullFlavor)])&lt;=1">(QUMT_IN020041NL): element hl7:acknowledgement[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:receiver)&gt;=1">(QUMT_IN020041NL): element hl7:receiver is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:receiver)&lt;=1">(QUMT_IN020041NL): element hl7:receiver komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:sender[not(@nullFlavor)])&gt;=1">(QUMT_IN020041NL): element hl7:sender[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count(hl7:sender[not(@nullFlavor)])&lt;=1">(QUMT_IN020041NL): element hl7:sender[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <let name="transmission" value="."/>
        <let name="interactionId" value="$transmission/local-name()"/>
        <let name="interactionVocabFile" value="'../vocab/2.16.840.1.113883.1.6.xml'"/>
        <let name="interactionVocab" value="if (doc-available($interactionVocabFile)) then doc($interactionVocabFile) else ()"/>
        <let name="interactionName" value="$interactionVocab/*/hl7:code[@code=$interactionId]/@displayName"/>
        <let name="isActive" value="not(exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Actief'][@value='false']))"/>
        <let name="allowBsn" value="exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetBsn'][@value='true'])"/>
        <let name="allowContextCode" value="exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetContextCode'][@value='true'])"/>
        <let name="senderGbpOrGbk" value="exists($transmission/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem=('2.16.840.1.113883.2.4.3.11.8','2.16.840.1.113883.2.4.3.11.6')])"/>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="$interactionVocab">(QUMT_IN020041NL): Transmission: <value-of select="$interactionVocabFile"/> niet gevonden. Controles gebaseerd op dit externe configuratiebestand zijn gedeactiveerd.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="not($interactionVocab) or $isActive">(QUMT_IN020041NL): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet (meer) Actief in <value-of select="$interactionVocabFile"/>
        </assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="not($interactionVocab) or not($allowBsn) or $transmission/hl7:attentionLine/hl7:keyWordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1']">(QUMT_IN020041NL): Transmission: er moet in deze interactie exact één AttentionLine met BSN zitten - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="not($interactionVocab) or  not($allowContextCode) or $transmission/hl7:attentionLine/hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']">(QUMT_IN020041NL): Transmission: er moet in deze interactie exact één AttentionLine met de ContextCode zitten - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="not($interactionVocab) or not($transmission/hl7:attentionLine/hl7:keywordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1']) or $allowBsn or $senderGbpOrGbk">(QUMT_IN020041NL): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet geconfigureerd voor gebruik van het element <value-of select="local-name()"/> voor BSN in <value-of select="$interactionVocabFile"/> en afzender is niet GBK of GBP</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="not($interactionVocab) or not($transmission/hl7:attentionLine/hl7:keywordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']) or $allowContextCode or $senderGbpOrGbk">(QUMT_IN020041NL): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet geconfigureerd voor gebruik van het element <value-of select="local-name()"/> voor ContextCode in <value-of select="$interactionVocabFile"/> en afzender is niet GBK of GBP</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count($transmission/hl7:attentionLine/hl7:keyWordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1'])&lt;=1">(QUMT_IN020041NL): Transmission: er mag maximaal één AttentionLine met BSN zijn - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.38" test="count($transmission/hl7:attentionLine/hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1'])&lt;=1">(QUMT_IN020041NL): Transmission: er mag maximaal één AttentionLine met de ContextCode zijn - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:id[not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:id[not(@nullFlavor)]" id="d909955e137-false-d909976e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="@root and @extension">(MCCI_MT000300): Transmission: id element mist root of extension</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:creationTime[not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:creationTime[not(@nullFlavor)]" id="d909955e142-false-d909989e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS.DATETIME.MIN"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="not(*)">(MCCI_MT000300): <value-of select="local-name()"/> met datatype TS.DATETIME.MIN, MAG GEEN elementen bevatten.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)]" id="d909955e147-false-d910005e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="@nullFlavor or (@code='NICTIZEd2005-Okt')">(MCCI_MT000300): de elementwaarde MOET een zijn van 'code 'NICTIZEd2005-Okt''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:interactionId[@root='2.16.840.1.113883.1.6']
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:interactionId[@root='2.16.840.1.113883.1.6']" id="d909955e151-false-d910024e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="string(@root)=('2.16.840.1.113883.1.6')">(MCCI_MT000300): de waarde van @root MOET '2.16.840.1.113883.1.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="not(@root='2.16.840.1.113883.1.6') or local-name(..)=@extension">(MCCI_MT000300): Transmission: @extension moet overeenkomen met het startelement van het bericht</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1']
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1']" id="d909955e157-false-d910041e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="string(@root)=('2.16.840.1.113883.2.4.3.11.1')">(MCCI_MT000300): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.1' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="string(@extension)=('810')">(MCCI_MT000300): de waarde van @extension MOET '810' zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:processingCode[@code='P'][not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:processingCode[@code='P'][not(@nullFlavor)]" id="d909955e162-false-d910062e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="@nullFlavor or (@code='P')">(MCCI_MT000300): de elementwaarde MOET een zijn van 'code 'P''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:processingModeCode[@code='T'][not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:processingModeCode[@code='T'][not(@nullFlavor)]" id="d909955e166-false-d910081e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="@nullFlavor or (@code='T')">(MCCI_MT000300): de elementwaarde MOET een zijn van 'code 'T''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:acceptAckCode[@code='NE'][not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:acceptAckCode[@code='NE'][not(@nullFlavor)]" id="d909955e171-false-d910100e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="@nullFlavor or (@code='NE')">(MCCI_MT000300): de elementwaarde MOET een zijn van 'code 'NE''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]" id="d909955e175-false-d910119e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="@typeCode">(MCCI_MT000300): attribute @typeCode MOET aanwezig zijn.</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.8-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000300): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.8' AcknowledgementType (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:targetMessage[not(@nullFlavor)])&gt;=1">(MCCI_MT000300): element hl7:targetMessage[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:targetMessage[not(@nullFlavor)])&lt;=1">(MCCI_MT000300): element hl7:targetMessage[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail" id="d909955e184-false-d910161e0">
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.19358-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000300): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.19358' AcknowledgementDetailType (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:code)&lt;=1">(MCCI_MT000300): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:text)&lt;=1">(MCCI_MT000300): element hl7:text komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:code
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:code" id="d909955e189-false-d910206e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:text
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:text" id="d909955e192-false-d910219e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ST"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:location
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:location" id="d909955e195-false-d910232e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ST"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:targetMessage[not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:targetMessage[not(@nullFlavor)]" id="d909955e198-false-d910245e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(MCCI_MT000300): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(MCCI_MT000300): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:targetMessage[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:targetMessage[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]" id="d909955e201-false-d910267e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:QUMT_IN020041NL/hl7:attentionLine
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:attentionLine" id="d910268e20-false-d910280e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:keyWordText[not(@nullFlavor)])&gt;=1">(TransmissionWrapperAttentionLine): element hl7:keyWordText[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:keyWordText[not(@nullFlavor)])&lt;=1">(TransmissionWrapperAttentionLine): element hl7:keyWordText[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:value[not(@nullFlavor)])&gt;=1">(TransmissionWrapperAttentionLine): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:value[not(@nullFlavor)])&lt;=1">(TransmissionWrapperAttentionLine): element hl7:value[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:QUMT_IN020041NL/hl7:attentionLine/hl7:keyWordText[not(@nullFlavor)]
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:attentionLine/hl7:keyWordText[not(@nullFlavor)]" id="d910268e23-false-d910314e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SC' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperAttentionLine): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SC" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="SC"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:QUMT_IN020041NL/hl7:attentionLine/hl7:value[not(@nullFlavor)]
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:attentionLine/hl7:value[not(@nullFlavor)]" id="d910268e32-false-d910327e0">
        <extends rule="ANY"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="@xsi:type">(TransmissionWrapperAttentionLine): attribute @xsi:type MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:receiver
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver" id="d909955e207-false-d910341e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="string(@typeCode)=('RCV') or not(@typeCode)">(MCCI_MT000300): de waarde van @typeCode MOET 'RCV' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:device[not(@nullFlavor)])&gt;=1">(MCCI_MT000300): element hl7:device[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:device[not(@nullFlavor)])&lt;=1">(MCCI_MT000300): element hl7:device[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]" id="d910348e20-false-d910370e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&gt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&lt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:name)&lt;=1">(TransmissionWrapperDevice): element hl7:name komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:agencyFor)&lt;=1">(TransmissionWrapperDevice): element hl7:agencyFor komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']" id="d910348e23-false-d910410e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(TransmissionWrapperDevice): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="@extension">(TransmissionWrapperDevice): attribute @extension MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:name" id="d910348e28-false-d910431e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor" id="d910348e31-false-d910444e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('AGNT') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'AGNT' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:representedOrganization)&lt;=1">(TransmissionWrapperDevice): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization" id="d910348e35-false-d910466e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('ORG') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(TransmissionWrapperDevice): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:NotificationParty)&lt;=1">(TransmissionWrapperDevice): element hl7:NotificationParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]" id="d910348e38-false-d910517e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name" id="d910348e41-false-d910530e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom" id="d910348e44-false-d910543e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty" id="d910348e47-false-d910557e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('CON') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&gt;=1">(TransmissionWrapperDevice): element hl7:contactParty is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&lt;=1">(TransmissionWrapperDevice): element hl7:contactParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id" id="d910563e18-false-d910606e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code" id="d910563e19-false-d910619e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr" id="d910563e20-false-d910632e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom" id="d910563e21-false-d910645e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty" id="d910563e22-false-d910658e0">
        <let name="elmcount" value="count(hl7:Organization|hl7:Person)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&gt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&lt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Organization)&lt;=1">(COCT_MT040203): element hl7:Organization komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Person)&lt;=1">(COCT_MT040203): element hl7:Person komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('ORG') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:id)&gt;=1">(COCT_MT150003): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contact)&gt;=1">(COCT_MT150003): element hl7:contact is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('CON') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contactPerson)&lt;=1">(COCT_MT150003): element hl7:contactPerson komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson">
        <extends rule="d910882e22-false-d911576e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:name)&gt;=1">(COCT_MT150003): element hl7:name is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name">
        <extends rule="d911562e21-false-d911651e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId">
        <extends rule="d911562e31-false-d911810e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT030203)
-->
    <rule id="d910882e22-false-d911576e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT030203)
-->
    <rule id="d911562e21-false-d911651e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule id="d911562e31-false-d911810e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:respondTo
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:respondTo" id="d909955e210-false-d912156e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="string(@typeCode)=('RSP') or not(@typeCode)">(MCCI_MT000300): de waarde van @typeCode MOET 'RSP' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:entityRsp[not(@nullFlavor)])&gt;=1">(MCCI_MT000300): element hl7:entityRsp[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:entityRsp[not(@nullFlavor)])&lt;=1">(MCCI_MT000300): element hl7:entityRsp[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:respondTo/hl7:telecom
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:respondTo/hl7:telecom" id="d909955e212-false-d912187e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]" id="d909955e213-false-d912200e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(MCCI_MT000300): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@classCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10882-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="not(@classCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000300): de waarde van classCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10882' EntityClass (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="not(@determinerCode) or (string-length(@determinerCode)&gt;0 and not(matches(@determinerCode,'\s')))">(MCCI_MT000300): attribuut @determinerCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@determinerCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10878-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="not(@determinerCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000300): de waarde van determinerCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10878' EntityDeterminer (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(MCCI_MT000300): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]" id="d909955e218-false-d912260e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:name
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:name" id="d909955e219-false-d912273e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:telecom
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:telecom" id="d909955e220-false-d912286e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.300
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]
Item: (MCCI_MT000300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]" id="d909955e221-false-d912300e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="string(@typeCode)=('SND') or not(@typeCode)">(MCCI_MT000300): de waarde van @typeCode MOET 'SND' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:device[not(@nullFlavor)])&gt;=1">(MCCI_MT000300): element hl7:device[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.300" test="count(hl7:device[not(@nullFlavor)])&lt;=1">(MCCI_MT000300): element hl7:device[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]" id="d912307e20-false-d912329e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&gt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&lt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:name)&lt;=1">(TransmissionWrapperDevice): element hl7:name komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:agencyFor)&lt;=1">(TransmissionWrapperDevice): element hl7:agencyFor komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']" id="d912307e23-false-d912369e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(TransmissionWrapperDevice): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="@extension">(TransmissionWrapperDevice): attribute @extension MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:name" id="d912307e28-false-d912390e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor" id="d912307e31-false-d912403e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('AGNT') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'AGNT' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:representedOrganization)&lt;=1">(TransmissionWrapperDevice): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization" id="d912307e35-false-d912425e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('ORG') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(TransmissionWrapperDevice): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:NotificationParty)&lt;=1">(TransmissionWrapperDevice): element hl7:NotificationParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]" id="d912307e38-false-d912476e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name" id="d912307e41-false-d912489e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom" id="d912307e44-false-d912502e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty" id="d912307e47-false-d912516e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('CON') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&gt;=1">(TransmissionWrapperDevice): element hl7:contactParty is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&lt;=1">(TransmissionWrapperDevice): element hl7:contactParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id" id="d912522e18-false-d912565e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code" id="d912522e19-false-d912578e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr" id="d912522e20-false-d912591e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom" id="d912522e21-false-d912604e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty
Item: (COCT_MT040203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty" id="d912522e22-false-d912617e0">
        <let name="elmcount" value="count(hl7:Organization|hl7:Person)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&gt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&lt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Organization)&lt;=1">(COCT_MT040203): element hl7:Organization komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Person)&lt;=1">(COCT_MT040203): element hl7:Person komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('ORG') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:id)&gt;=1">(COCT_MT150003): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contact)&gt;=1">(COCT_MT150003): element hl7:contact is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('CON') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contactPerson)&lt;=1">(COCT_MT150003): element hl7:contactPerson komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson">
        <extends rule="d912841e22-false-d913535e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:name)&gt;=1">(COCT_MT150003): element hl7:name is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name">
        <extends rule="d913521e21-false-d913610e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId">
        <extends rule="d913521e31-false-d913769e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT030203)
-->
    <rule id="d912841e22-false-d913535e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT030203)
-->
    <rule id="d913521e21-false-d913610e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule id="d913521e31-false-d913769e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.40
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess
Item: (ControlActQueryResponse-MFMT_MT902200NL)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess" id="d914108e42-false-d914119e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="string(@moodCode)=('EVN')">(ControlActQueryResponse-MFMT_MT902200NL): de waarde van @moodCode MOET 'EVN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(ControlActQueryResponse-MFMT_MT902200NL): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="count(hl7:code)&lt;=1">(ControlActQueryResponse-MFMT_MT902200NL): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="count(hl7:effectiveTime)&lt;=1">(ControlActQueryResponse-MFMT_MT902200NL): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="count(hl7:authorOrPerformer[not(@nullFlavor)])&gt;=1">(ControlActQueryResponse-MFMT_MT902200NL): element hl7:authorOrPerformer[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="count(hl7:authorOrPerformer[not(@nullFlavor)])&lt;=1">(ControlActQueryResponse-MFMT_MT902200NL): element hl7:authorOrPerformer[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="count(hl7:queryAck)&gt;=1">(ControlActQueryResponse-MFMT_MT902200NL): element hl7:queryAck is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="count(hl7:queryAck)&lt;=1">(ControlActQueryResponse-MFMT_MT902200NL): element hl7:queryAck komt te vaak voor [max 1x].</assert>
        <let name="controlActProcess" value="."/>
        <let name="authorEntity" value="$controlActProcess/hl7:authorOrPerformer//hl7:*[lower-case(local-name())=('assigneddevice','assignedperson')][1]"/>
        <let name="authorDevice" value="$authorEntity[lower-case(local-name())='assigneddevice']"/>
        <let name="authorPerson" value="$authorEntity[lower-case(local-name())='assignedperson']"/>
        <let name="overseerPerson" value="$controlActProcess/hl7:overseer//hl7:*[lower-case(local-name())=('assignedentity','assignedperson')][1]"/>
        <let name="authorPath" value="string-join($authorEntity/ancestor-or-self::*/name(),'/')"/>
        <let name="overseerPath" value="string-join($overseerPerson/ancestor-or-self::*/name(),'/')"/>
        <let name="senderApplicationId" value="$controlActProcess/../hl7:sender/hl7:device/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>
        <let name="authorApplicationId" value="$authorDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>
        <let name="overseerOrgId" value="$overseerPerson/hl7:Organization/hl7:id"/>
        <let name="authorOrgId" value="$authorEntity/hl7:Organization/hl7:id"/>
        <let name="interactionId" value="$controlActProcess/../local-name()"/>
        <let name="interactionVocabFile" value="'../vocab/2.16.840.1.113883.1.6.xml'"/>
        <let name="interactionVocab" value="if (doc-available($interactionVocabFile)) then doc($interactionVocabFile) else ()"/>
        <let name="interactionTrustLevel" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Vertrouwensniveau']/@value"/>
        <let name="interactionSendType" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Verzendtype']/@value"/>
        <let name="interactionTriggerEventCode" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:reference/@extension"/>
        <let name="messageTriggerEventCode" value="$controlActProcess/hl7:code/@code"/>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="$interactionVocab">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$interactionVocabFile"/> niet gevonden. Controles gebaseerd op dit externe configuratiebestand zijn gedeactiveerd.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($controlActProcess/hl7:queryByParameter) or $controlActProcess[@moodCode='EVN']">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="local-name()"/>/@moodCode moet 'EVN' zijn bij queries</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($interactionVocab) or not($messageTriggerEventCode) or $interactionTriggerEventCode=$messageTriggerEventCode">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="local-name()"/>/code (Trigger Event) moet bij deze interactie '<value-of select="$interactionTriggerEventCode"/>' zijn, gevonden is echter '<value-of select="$messageTriggerEventCode"/>'</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($interactionVocab) or $authorPerson or not($interactionTrustLevel) or $interactionTrustLevel='Laag'">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="local-name()"/>/authorOrPerformer moet een persoon bevatten in berichten met vertrouwensniveau midden of hoog</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($interactionVocab) or $overseerPerson or empty($interactionTrustLevel) or $interactionTrustLevel='Laag'">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="local-name()"/>/overseer moet de mandaterende persoon bevatten in berichten met vertrouwensniveau midden of hoog</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($authorEntity//hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or not($authorEntity/../(hl7:queryByParameter|hl7:subject)//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or $authorEntity/../../hl7:attentionLine">(ControlActQueryResponse-MFMT_MT902200NL): Patiëntgebonden interacties, verzonden vanuit een patiëntenportaal (GBP), moeten een attentionLine hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($authorEntity//hl7:id[@root=('2.16.840.1.113883.2.4.3.11.7.3','2.16.528.1.1003.1.3.5.4.1')]) or not($authorEntity/../(hl7:queryByParameter|hl7:subject)//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or $authorEntity/../../hl7:attentionLine">(ControlActQueryResponse-MFMT_MT902200NL): Patiëntgebonden interacties, verzonden vanuit het klantenloket (GBK), moeten een attentionLine hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="empty($senderApplicationId) or empty($authorApplicationId) or $senderApplicationId=$authorApplicationId or $senderApplicationId='1'">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/id. Applicatie-id <value-of select="$authorApplicationId"/> komt niet overeen met Transmission-wrapper sender <value-of select="$senderApplicationId"/>.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($authorDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']) or $authorDevice/hl7:id[@root='2.16.528.1.1007.3.2']">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/id moet tenminste het UZI-nummer systemen bevatten voor een XIS in een GBZ</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($authorDevice/hl7:id[@root='2.16.528.1.1007.3.2']) or $authorDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3' and @extension]">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/id moet de zorgaanbieder van het XIS identificeren</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($authorDevice) or $authorDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6'][@extension='1'] or $authorDevice/hl7:id[@root='2.16.528.1.1007.4'] or $authorDevice/hl7:Organization/hl7:id">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/ moet een geïdentificeerde organisatie hebben, tenzij het de ZIM of het SBV-Z betreft.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($authorPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P']">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/code/@code moet "P" (Patiënt) zijn. Wettelijke vertegenwoordigers moet dit via het Klantenloket doen en kunnen dus niet als auteur optreden</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($authorPerson/hl7:id[@root=('2.16.840.1.113883.2.4.3.11.7.3','2.16.528.1.1003.1.3.5.4.1')]) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='KLANTENLOKET']">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/code/@code moet "KLANTENLOKET" zijn voor klantenloketmedewerkers</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($authorPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/code ontbreekt. Dit is alleen toegestaan als de rolcode 00.000 is.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($authorPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $authorOrgId[@root='2.16.528.1.1007.3.3' and @extension]">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/Organization/id moet de zorgaanbieder van de persoon identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($authorPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $authorOrgId[@root='2.16.840.1.113883.2.4.3.11.25']">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/Organization/id/@root moet '2.16.840.1.113883.2.4.3.11.25' bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($authorPerson/hl7:id[@root=('2.16.840.1.113883.2.4.3.11','2.16.528.1.1003.1.3.5.4.1')]) or $authorOrgId[@root='2.16.840.1.113883.2.4.3.11'][@extension='7']">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/Organization/id moet de Nictiz-klantenloket organisatie identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($overseerPerson/hl7:Organization[not(hl7:name)]/hl7:id[@root='2.16.528.1.1007.3.3'])">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/Organization/name moet de zorgaanbieder/organisatienaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($overseerPerson/hl7:Organization[not(hl7:name)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11' and @extension='7'])">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$authorPath"/>/Organization/name moet de Nictiz-klantenloket organisatienaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($overseerPerson) or $overseerPerson/hl7:code">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$overseerPath"/>/code is verplicht</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($overseerPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $overseerPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P'] or $overseerPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.6']">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$overseerPath"/>/code/@code moet "P" (Patiënt) zijn of een geldige waarde uit RoleCodeWettelijkeVertegenwoordigerNL</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson/hl7:name">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$overseerPath"/>/assignedPrincipalChoiceList/assignedPerson/name is verplicht</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$overseerPath"/>/Organization/id moet de zorgaanbieder van de persoon identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:name">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$overseerPath"/>//Organization/name moet de zorgaanbiedernaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:addr/hl7:city">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$overseerPath"/>/Organization/addr moet tennminste de vestigingsplaats bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not($overseerOrgId) or $authorOrgId[@root=$overseerOrgId/@root][@extension=$overseerOrgId/@extension] or $authorEntity[lower-case(local-name())='assigneddevice']">(ControlActQueryResponse-MFMT_MT902200NL): Control Act: <value-of select="$overseerPath"/>/Organization/id. Organisatie van de overseer (<value-of select="$overseerOrgId/@root"/>#<value-of select="$overseerOrgId/@extension"/>) moet gelijk zijn aan die van de authorOrPerformer (<value-of select="$authorOrgId/@extension"/>)</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.40
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:code
Item: (ControlActQueryResponse-MFMT_MT902200NL)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:code" id="d914108e46-false-d914203e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActQueryResponse-MFMT_MT902200NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="@nullFlavor or (@codeSystem='2.16.840.1.113883.1.18')">(ControlActQueryResponse-MFMT_MT902200NL): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.1.18''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.40
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:effectiveTime
Item: (ControlActQueryResponse-MFMT_MT902200NL)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:effectiveTime" id="d914108e54-false-d914222e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActQueryResponse-MFMT_MT902200NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not(*)">(ControlActQueryResponse-MFMT_MT902200NL): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer
Item: (ControlActAuthorOrPerformer)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer" id="d914223e57-false-d914238e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="@typeCode">(ControlActAuthorOrPerformer): attribute @typeCode MOET aanwezig zijn.</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.19080-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(ControlActAuthorOrPerformer): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.19080' x_ParticipationAuthorPerformer (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="count(hl7:participant[not(@nullFlavor)])&gt;=1">(ControlActAuthorOrPerformer): element hl7:participant[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="count(hl7:participant[not(@nullFlavor)])&lt;=1">(ControlActAuthorOrPerformer): element hl7:participant[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]
Item: (ControlActAuthorOrPerformer)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]" id="d914223e64-false-d914274e0">
        <let name="elmcount" value="count(hl7:AssignedDevice|hl7:AssignedPerson)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="$elmcount&gt;=1">(ControlActAuthorOrPerformer): keuze (hl7:AssignedDevice of hl7:AssignedPerson) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="$elmcount&lt;=1">(ControlActAuthorOrPerformer): keuze (hl7:AssignedDevice of hl7:AssignedPerson) bevat te veel elementen [max 1x]</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice
Item: (ControlActAuthorOrPerformer)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.2']|hl7:id[@root='2.16.840.1.113883.2.4.6.6']|hl7:id[@root='2.16.528.1.1007.4'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&gt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.2'] of hl7:id[@root='2.16.840.1.113883.2.4.6.6'] of hl7:id[@root='2.16.528.1.1007.4']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&lt;=2">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.2'] of hl7:id[@root='2.16.840.1.113883.2.4.6.6'] of hl7:id[@root='2.16.528.1.1007.4']) bevat te veel elementen [max 2x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:Organization)&lt;=1">(COCT_MT090300): element hl7:Organization komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1010
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.3.2']
Item: (dtUZIsystemen)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.3.2']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1010" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtUZIsystemen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.UZI"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1010" test="string(@root)=('2.16.528.1.1007.3.2')">(dtUZIsystemen): de waarde van @root MOET '2.16.528.1.1007.3.2' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1008
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (dtAortaApplicationId)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1008" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtAortaApplicationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1008" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(dtAortaApplicationId): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1018
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.4']
Item: (dtSBV-Zsystemen)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.4']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1018" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-Zsystemen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1018" test="string(@root)=('2.16.528.1.1007.4')">(dtSBV-Zsystemen): de waarde van @root MOET '2.16.528.1.1007.4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id[@root='2.16.528.1.1007']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']|hl7:id[@root='2.16.840.1.113883.2.4.3.11'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&gt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&lt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:code)&lt;=1">(COCT_MT090300): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090300): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090300): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:addr)&lt;=1">(COCT_MT090300): element hl7:addr komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1011
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (dtURAorganization)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtURAorganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.URA"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="string(@root)=('2.16.528.1.1007.3.3')">(dtURAorganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1019
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007']
Item: (dtSBV-ZOrganizationId)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-ZOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@root)=('2.16.528.1.1007')">(dtSBV-ZOrganizationId): de waarde van @root MOET '2.16.528.1.1007' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@extension)=('4')">(dtSBV-ZOrganizationId): de waarde van @extension MOET '4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1020
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']
Item: (dtGBO-GBP)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBO-GBP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="string(@root)=('2.16.840.1.113883.2.4.3.11.25')">(dtGBO-GBP): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.25' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1021
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11']
Item: (dtGBKOrganizationId)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBKOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@root)=('2.16.840.1.113883.2.4.3.11')">(dtGBKOrganizationId): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@extension)=('7')">(dtGBKOrganizationId): de waarde van @extension MOET '7' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:code
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090300): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.1 RoleCodeNL - zorgaanbiedertype (organisaties) (DYNAMISCH)'.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:telecom
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:city[not(@nullFlavor)])&gt;=1">(COCT_MT090300): element hl7:city[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:city[not(@nullFlavor)])&lt;=1">(COCT_MT090300): element hl7:city[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (COCT_MT090300)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:templateId
Item: (COCT_MT090300)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson
Item: (ControlActAuthorOrPerformer)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id[@root='2.16.840.1.113883.2.4.6.3']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']|hl7:id[@root='2.16.528.1.1003.1.3.5.4.1'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.1'])&lt;=1">(COCT_MT090100): element hl7:id[@root='2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:telecom)&lt;=1">(COCT_MT090100): element hl7:telecom komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPrincipalChoiceList)&lt;=1">(COCT_MT090100): element hl7:assignedPrincipalChoiceList komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1009
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (dtUZIpersonen)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1007.3.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtUZIpersonen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.UZI"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="string(@root)=('2.16.528.1.1007.3.1')">(dtUZIpersonen): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1012
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (dtBSN)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBSN): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.BSN"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(dtBSN): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">(dtBSN): attribuut @root MOET datatype 'oid' hebben</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1015
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']
Item: (dtBatchInzageAuteur)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBatchInzageAuteur): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="string(@root)=('2.16.840.1.113883.2.4.3.11.7.3')">(dtBatchInzageAuteur): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.7.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1016
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']
Item: (dtNictizKlantenloketPKIO)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtNictizKlantenloketPKIO): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="string(@root)=('2.16.528.1.1003.1.3.5.4.1')">(dtNictizKlantenloketPKIO): de waarde van @root MOET '2.16.528.1.1003.1.3.5.4.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1017
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.1']
Item: (dtAGB)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtAGB): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.AGB"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="string(@root)=('2.16.840.1.113883.2.4.6.1')">(dtAGB): de waarde van @root MOET '2.16.840.1.113883.2.4.6.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.5-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.4 RoleCodeNL - toegang patiënt (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.5 RoleCodeNL - wettelijke vertegenwoording (DYNAMISCH)'.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="not(@code='00.000' and @codeSystem='2.16.840.1.113883.2.4.15.111')">(COCT_MT090100): Control Act: <name path=".."/>/<name/> moet een UZI-rolcode 00.000 is niet toegestaan</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id[@root='2.16.528.1.1007']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']|hl7:id[@root='2.16.840.1.113883.2.4.3.11'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:addr)&lt;=1">(COCT_MT090100): element hl7:addr komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1011
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (dtURAorganization)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtURAorganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.URA"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="string(@root)=('2.16.528.1.1007.3.3')">(dtURAorganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1019
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']
Item: (dtSBV-ZOrganizationId)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-ZOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@root)=('2.16.528.1.1007')">(dtSBV-ZOrganizationId): de waarde van @root MOET '2.16.528.1.1007' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@extension)=('4')">(dtSBV-ZOrganizationId): de waarde van @extension MOET '4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1020
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']
Item: (dtGBO-GBP)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBO-GBP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="string(@root)=('2.16.840.1.113883.2.4.3.11.25')">(dtGBO-GBP): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.25' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1021
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']
Item: (dtGBKOrganizationId)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBKOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@root)=('2.16.840.1.113883.2.4.3.11')">(dtGBKOrganizationId): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@extension)=('7')">(dtGBKOrganizationId): de waarde van @extension MOET '7' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.1 RoleCodeNL - zorgaanbiedertype (organisaties) (DYNAMISCH)'.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:city)&lt;=1">(COCT_MT090100): element hl7:city komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr/hl7:city
Item: (COCT_MT090100)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:templateId
Item: (COCT_MT090100)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.40
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:subject
Item: (ControlActQueryResponse-MFMT_MT902200NL)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:subject" id="d914108e72-false-d915380e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="string(@typeCode)=('SUBJ') or not(@typeCode)">(ControlActQueryResponse-MFMT_MT902200NL): de waarde van @typeCode MOET 'SUBJ' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(ControlActQueryResponse-MFMT_MT902200NL): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="string(@contextConductionInd)=('false') or not(@contextConductionInd)">(ControlActQueryResponse-MFMT_MT902200NL): de waarde van @contextConductionInd MOET 'false' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not(@contextConductionInd) or string(@contextConductionInd)=('true','false')">(ControlActQueryResponse-MFMT_MT902200NL): attribuut @contextConductionInd MOET datatype 'bl' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="count(hl7:ActReference[not(@nullFlavor)])&lt;=1">(ControlActQueryResponse-MFMT_MT902200NL): element hl7:ActReference[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.39
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:subject/hl7:ActReference[not(@nullFlavor)]
Item: (MFMT_MT902200NL)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:subject/hl7:ActReference[not(@nullFlavor)]" id="d915397e16-false-d915416e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.39" test="string(@classCode)=('CATEGORY')">(MFMT_MT902200NL): de waarde van @classCode MOET 'CATEGORY' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.39" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(MFMT_MT902200NL): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.39" test="string(@moodCode)=('EVN')">(MFMT_MT902200NL): de waarde van @moodCode MOET 'EVN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.39" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(MFMT_MT902200NL): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.39" test="count(hl7:recordTarget[not(@nullFlavor)])&gt;=1">(MFMT_MT902200NL): element hl7:recordTarget[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.39" test="count(hl7:recordTarget[not(@nullFlavor)])&lt;=1">(MFMT_MT902200NL): element hl7:recordTarget[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.39
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:subject/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]
Item: (MFMT_MT902200NL)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:subject/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]" id="d915397e19-false-d915453e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.39" test="count(hl7:patient[not(@nullFlavor)])&gt;=1">(MFMT_MT902200NL): element hl7:patient[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.39" test="count(hl7:patient[not(@nullFlavor)])&lt;=1">(MFMT_MT902200NL): element hl7:patient[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.41
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:subject/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]/hl7:patient
Item: (RPatientNL-COQT_MT050001NL)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:subject/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]/hl7:patient" id="d915470e10-false-d915478e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.41" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&gt;=1">(RPatientNL-COQT_MT050001NL): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.41" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&lt;=1">(RPatientNL-COQT_MT050001NL): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.41
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:subject/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]/hl7:patient/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (RPatientNL-COQT_MT050001NL)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:subject/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]/hl7:patient/hl7:id[@root='2.16.840.1.113883.2.4.6.3']" id="d915470e11-false-d915500e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.41" test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(RPatientNL-COQT_MT050001NL): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.41" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(RPatientNL-COQT_MT050001NL): attribuut @root MOET datatype 'uid' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.41" test="@extension">(RPatientNL-COQT_MT050001NL): attribute @extension MOET aanwezig zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.41" test="not(@extension) or string-length(@extension)&gt;0">(RPatientNL-COQT_MT050001NL): attribuut @extension MOET datatype 'st' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.40
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf
Item: (ControlActQueryResponse-MFMT_MT902200NL)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf" id="d914108e88-false-d915523e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="string(@typeCode)=('RSON') or not(@typeCode)">(ControlActQueryResponse-MFMT_MT902200NL): de waarde van @typeCode MOET 'RSON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(ControlActQueryResponse-MFMT_MT902200NL): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="not(@contextConductionInd) or string(@contextConductionInd)=('true','false')">(ControlActQueryResponse-MFMT_MT902200NL): attribuut @contextConductionInd MOET datatype 'bl' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="count(hl7:justifiedDetectedIssue)&gt;=1">(ControlActQueryResponse-MFMT_MT902200NL): element hl7:justifiedDetectedIssue is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.40" test="count(hl7:justifiedDetectedIssue)&lt;=1">(ControlActQueryResponse-MFMT_MT902200NL): element hl7:justifiedDetectedIssue komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.40
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue
Item: (ControlActQueryResponse-MFMT_MT902200NL)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="string(@classCode)=('ALRT') or not(@classCode)">(DetectedIssueEvent): de waarde van @classCode MOET 'ALRT' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(DetectedIssueEvent): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="string(@moodCode)=('EVN') or not(@moodCode)">(DetectedIssueEvent): de waarde van @moodCode MOET 'EVN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(DetectedIssueEvent): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@nullFlavor) or (string-length(@nullFlavor)&gt;0 and not(matches(@nullFlavor,'\s')))">(DetectedIssueEvent): attribuut @nullFlavor MOET datatype 'cs' hebben</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="hl7:code[@code and @displayName] or hl7:text or hl7:value">(DetectedIssueEvent): Control Act: Bij voorkeur moet code/@displayName, text of value een uitgebreidere toelichting op de fout/waarschuwing bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:code)&gt;=1">(DetectedIssueEvent): element hl7:code is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:code)&lt;=1">(DetectedIssueEvent): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:text)&lt;=1">(DetectedIssueEvent): element hl7:text komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:value)&lt;=1">(DetectedIssueEvent): element hl7:value komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:id
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DetectedIssueEvent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:code
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DetectedIssueEvent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:text
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:text">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DetectedIssueEvent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ED"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:value
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:value">
        <extends rule="ANY"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="string(@typeCode)=('TRIG') or not(@typeCode)">(DetectedIssueEvent): de waarde van @typeCode MOET 'TRIG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(DetectedIssueEvent): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@contextConductionInd) or string(@contextConductionInd)=('true','false')">(DetectedIssueEvent): attribuut @contextConductionInd MOET datatype 'bl' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@negationInd) or string(@negationInd)=('true','false')">(DetectedIssueEvent): attribuut @negationInd MOET datatype 'bl' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@nullFlavor) or (string-length(@nullFlavor)&gt;0 and not(matches(@nullFlavor,'\s')))">(DetectedIssueEvent): attribuut @nullFlavor MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:actOrderRequired)&gt;=1">(DetectedIssueEvent): element hl7:actOrderRequired is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:actOrderRequired)&lt;=1">(DetectedIssueEvent): element hl7:actOrderRequired komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(DetectedIssueEvent): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@classCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.155-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@classCode) or count($theAttValue) = count($theAttCheck)">(DetectedIssueEvent): de waarde van classCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.155' AcknowledgementCondition (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(DetectedIssueEvent): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@moodCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10196-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@moodCode) or count($theAttValue) = count($theAttCheck)">(DetectedIssueEvent): de waarde van moodCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10196' ActMood (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@nullFlavor) or (string-length(@nullFlavor)&gt;0 and not(matches(@nullFlavor,'\s')))">(DetectedIssueEvent): attribuut @nullFlavor MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:code)&lt;=1">(DetectedIssueEvent): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:effectiveTime)&lt;=1">(DetectedIssueEvent): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired/hl7:code
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DetectedIssueEvent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired/hl7:effectiveTime
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired/hl7:effectiveTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SXCM_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DetectedIssueEvent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SXCM_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="SXCM_TS"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired/hl7:subject
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired/hl7:subject">
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10901-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(DetectedIssueEvent): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10901' ParticipationType (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@nullFlavor) or (string-length(@nullFlavor)&gt;0 and not(matches(@nullFlavor,'\s')))">(DetectedIssueEvent): attribuut @nullFlavor MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:participant)&gt;=1">(DetectedIssueEvent): element hl7:participant is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:participant)&lt;=1">(DetectedIssueEvent): element hl7:participant komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired/hl7:subject/hl7:participant
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired/hl7:subject/hl7:participant">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(DetectedIssueEvent): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@classCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.11555-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@classCode) or count($theAttValue) = count($theAttCheck)">(DetectedIssueEvent): de waarde van classCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.11555' RoleClass (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:code)&lt;=1">(DetectedIssueEvent): element hl7:code komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired/hl7:subject/hl7:participant/hl7:code
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:triggerFor/hl7:actOrderRequired/hl7:subject/hl7:participant/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DetectedIssueEvent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:targetOf
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:targetOf">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(DetectedIssueEvent): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10317-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(DetectedIssueEvent): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10317' ActRelationshipType (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@nullFlavor) or (string-length(@nullFlavor)&gt;0 and not(matches(@nullFlavor,'\s')))">(DetectedIssueEvent): attribuut @nullFlavor MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="string(@contextConductionInd)=('false') or not(@contextConductionInd)">(DetectedIssueEvent): de waarde van @contextConductionInd MOET 'false' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@contextConductionInd) or string(@contextConductionInd)=('true','false')">(DetectedIssueEvent): attribuut @contextConductionInd MOET datatype 'bl' hebben</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:targetOf/hl7:source
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:targetOf/hl7:source">
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@classCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.155-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@classCode) or count($theAttValue) = count($theAttCheck)">(DetectedIssueEvent): de waarde van classCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.155' AcknowledgementCondition (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="@moodCode">(DetectedIssueEvent): attribute @moodCode MOET aanwezig zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(DetectedIssueEvent): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@moodCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.19375-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@moodCode) or count($theAttValue) = count($theAttCheck)">(DetectedIssueEvent): de waarde van moodCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.19375' x_ActMoodDefEvn (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="not(@nullFlavor) or (string-length(@nullFlavor)&gt;0 and not(matches(@nullFlavor,'\s')))">(DetectedIssueEvent): attribuut @nullFlavor MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:code)&lt;=1">(DetectedIssueEvent): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="count(hl7:text)&lt;=1">(DetectedIssueEvent): element hl7:text komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:targetOf/hl7:source/hl7:code
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:targetOf/hl7:source/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DetectedIssueEvent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CD"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.508
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:targetOf/hl7:source/hl7:text
Item: (DetectedIssueEvent)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:reasonOf/hl7:justifiedDetectedIssue/hl7:targetOf/hl7:source/hl7:text">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.508" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DetectedIssueEvent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ED"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.506
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck
Item: (QueryAck)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck" id="d916105e33-false-d916118e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="count(hl7:queryId[not(@nullFlavor)])&gt;=1">(QueryAck): element hl7:queryId[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="count(hl7:queryId[not(@nullFlavor)])&lt;=1">(QueryAck): element hl7:queryId[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="count(hl7:statusCode)&lt;=1">(QueryAck): element hl7:statusCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="count(hl7:queryResponseCode[@code=doc('include/voc-2.16.840.1.113883.1.11.208-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)])&gt;=1">(QueryAck): element hl7:queryResponseCode[@code=doc('include/voc-2.16.840.1.113883.1.11.208-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="count(hl7:queryResponseCode[@code=doc('include/voc-2.16.840.1.113883.1.11.208-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)])&lt;=1">(QueryAck): element hl7:queryResponseCode[@code=doc('include/voc-2.16.840.1.113883.1.11.208-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="count(hl7:resultTotalQuantity)&gt;=1">(QueryAck): element hl7:resultTotalQuantity is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="count(hl7:resultTotalQuantity)&lt;=1">(QueryAck): element hl7:resultTotalQuantity komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="count(hl7:resultCurrentQuantity[not(@nullFlavor)])&gt;=1">(QueryAck): element hl7:resultCurrentQuantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="count(hl7:resultCurrentQuantity[not(@nullFlavor)])&lt;=1">(QueryAck): element hl7:resultCurrentQuantity[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="count(hl7:resultRemainingQuantity)&gt;=1">(QueryAck): element hl7:resultRemainingQuantity is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="count(hl7:resultRemainingQuantity)&lt;=1">(QueryAck): element hl7:resultRemainingQuantity komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.506
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:queryId[not(@nullFlavor)]
Item: (QueryAck)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:queryId[not(@nullFlavor)]" id="d916105e36-false-d916199e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryAck): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.506
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:statusCode
Item: (QueryAck)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:statusCode" id="d916105e42-false-d916212e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryAck): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="@nullFlavor or (@code='aboerted') or (@code='deliveredResponse')">(QueryAck): de elementwaarde MOET een zijn van 'code 'aboerted' of code 'deliveredResponse''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.506
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:queryResponseCode[@code=doc('include/voc-2.16.840.1.113883.1.11.208-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)]
Item: (QueryAck)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:queryResponseCode[@code=doc('include/voc-2.16.840.1.113883.1.11.208-2011-07-26T000000.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)]" id="d916105e58-false-d916236e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryAck): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.208-2011-07-26T000000.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(QueryAck): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.208 QueryResponse (2011-07-26T00:00:00)'.</assert>
        <let name="acknowledgementTypeCode" value="../../../hl7:acknowledgement/@typeCode"/>
        <let name="resultCurrentQuantity" value="../hl7:resultCurrentQuantity/@value"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="not($acknowledgementTypeCode='AA') or @code=('NF','OK')">(QueryAck): Control Act: queryAck/queryResponseCode moet bij een positief antwoord 'OK' of 'NF' zijn</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="not($acknowledgementTypeCode='AA' and @code=('AE','QE'))">(QueryAck): Control Act: queryAck/queryResponseCode moet bij een negatief antwoord 'AE' of 'QE' zijn</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="not(@code='OK') or ($acknowledgementTypeCode='AA' and $resultCurrentQuantity &gt; 0)">(QueryAck): Control Act: queryAck/queryResponseCode moet 'OK' bevatten indien er op basis van de queryParameters resultaten gevonden konden worden (resultCurrentQuantity/@value='<value-of select="$resultCurrentQuantity"/>') en de query valide is (acknowledgement/@typeCode='<value-of select="$acknowledgementTypeCode"/>')</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="not(@code='NF') or ($acknowledgementTypeCode='AA' and $resultCurrentQuantity = 0)">(QueryAck): Control Act: queryAck/queryResponseCode moet 'NF' bevatten indien er op basis van de queryParameters geen resultaten gevonden konden worden (resultCurrentQuantity/@value='<value-of select="$resultCurrentQuantity"/>') en de query valide is (acknowledgement/@typeCode='<value-of select="$acknowledgementTypeCode"/>')</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.506
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:resultTotalQuantity
Item: (QueryAck)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:resultTotalQuantity" id="d916105e106-false-d916257e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryAck): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="INT.NONNEG"/>
        <let name="digitok" value="matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="$digitok or @nullFlavor">(QueryAck): @value is geen geldig INT getal <value-of select="@value"/>
        </assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="string(@nullFlavor)=('NAV') or not(@nullFlavor)">(QueryAck): de waarde van @nullFlavor MOET 'NAV' zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.506
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:resultCurrentQuantity[not(@nullFlavor)]
Item: (QueryAck)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:resultCurrentQuantity[not(@nullFlavor)]" id="d916105e123-false-d916277e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryAck): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="INT.NONNEG"/>
        <let name="digitok" value="matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="$digitok or @nullFlavor">(QueryAck): @value is geen geldig INT getal <value-of select="@value"/>
        </assert>
        <let name="resultCurrentQuantity" value="count(../../hl7:subject)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="@value=$resultCurrentQuantity">(QueryAck): Control Act: queryAck/resultCurrentQuantity '<value-of select="@value"/>' moet gelijk zijn aan het aantal subject elementen ('<value-of select="$resultCurrentQuantity"/>')</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.506
Context: /hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:resultRemainingQuantity
Item: (QueryAck)
-->
    <rule context="/hl7:QUMT_IN020041NL/hl7:ControlActProcess/hl7:queryAck/hl7:resultRemainingQuantity" id="d916105e137-false-d916293e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(QueryAck): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="INT.NONNEG"/>
        <let name="digitok" value="matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="$digitok or @nullFlavor">(QueryAck): @value is geen geldig INT getal <value-of select="@value"/>
        </assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="string(@nullFlavor)=('NAV') or not(@nullFlavor)">(QueryAck): de waarde van @nullFlavor MOET 'NAV' zijn.</assert>
        <let name="resultTotalQuantity" value="../hl7:resultTotalQuantity/@value"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.506" test="not(@value and $resultTotalQuantity) or (number(@value) &lt;= number($resultTotalQuantity))">(QueryAck): Control Act: queryAck/resultRemainingQuantity '<value-of select="@value"/>' moet kleiner dan of gelijk aan resultTotalQuantity '<value-of select="$resultTotalQuantity"/>' zijn</assert>
    </rule>
</pattern>